import re

def charExistenceSet(string, validChars):
    charSet = dict()
    for char in validChars:
        charSet[char] = (char in string)
    return charSet

def lastPosSet(string, validChars):
    lastposSet = dict()
    for char in validChars:
        rpos = string.rfind(char)
        if rpos == -1:
            lastposSet[char] = -1
        else:
            lastposSet[char] = rpos
    return lastposSet


def builtin1(S, T):
    return [str(x.start()) for x in re.finditer(S, T)]

def algorithm1(S, T):   #basic python style algorithm
    matches = []
    S_len = len(S)
    for index, substring in enumerate(T):
        if(S_len > len(T[index:index+S_len])):   #remaining T to short for S string
            break
        
        for x, y in zip(S, T[index:index+S_len]): #check the characters of the match candidate
            if(x != y): #one character of the match candidate and the S string is not identical
                break   # ->no valid match, break out of inner loop
        else:
            print(f"{index} - {index+S_len-1}")
            matches.append(str(index))   #math found, because all characters are identical
    return matches      

def algorithm2(S, T, validChars="ACGTURYKMSWBDHVN"):    #jump multiple steps if current char is not in charSet 
    charSet = charExistenceSet(S, validChars)  
    S_len = len(S)  
    i = 0 
    matches = []
    while i<=len(T)-S_len:
        j = S_len-1
        while(j>=0 and charSet[T[i+j]] and S[j]==T[i+j]):
            j -= 1
        if(j == -1):
            #print(f"{i} - {i+S_len-1}")
            matches.append(str(i)); 
        elif(not charSet[T[i+j]]):
            i += j
        i += 1 
    return matches     

def algorithm3(S, T, validChars="ACGTURYKMSWBDHVN"):    #aditionally jump to the first occurence of a character that is missmatched
    charSet = charExistenceSet(S, validChars)
    posSet = lastPosSet(S, validChars)
    S_len = len(S)
    i = 0 
    matches = []
    while i<=len(T)-S_len:
        j = S_len-1
        while(j>=0 and S[j]==T[i+j] and charSet[T[i+j]]):
            j -= 1
        if(j == -1):
            print(f"{i} - {i+S_len-1}")
            matches.append(str(i)); 
            i += 1 
        elif(posSet[T[i+j]] < j):
            i += j - posSet[T[i+j]]
        else:
            i += 1
    return matches